package tests;

import java.awt.Component;

import javax.swing.JFrame;

import control.BoardController;
import model.Board;
import model.MineException;
import model.generators.ConcreteBoardGenerator;
import view.BoardView;
import view.SimpleBoxDrawer;

public class BoardViewControlledTest {

	public static void main(String[] args) throws MineException {

		JFrame frame = new JFrame();
		frame.setVisible(true);
		Board board = new Board(new ConcreteBoardGenerator(3, 5));
		BoardView boardView = new BoardView(board, new SimpleBoxDrawer(30));
		frame.getContentPane().add(boardView);
		boardView.addMouseListener(new BoardController(board));
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
}
